//---------------------------------------------------------------------------
#ifndef fscenauporzadkowanaH
#define fscenauporzadkowanaH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ExtCtrls.hpp>
#include <ComCtrls.hpp>

#include <vector>
//---------------------------------------------------------------------------
//  Klasa opisujca wirtualne przedmioty.
//  Operator '<' moliwo sortowania przedmiotw wg. odlegoci od obserwatora.
class TPrzedmiot
{
private:
public:
    TPunkt p0;                      //ciao przedmiotu (tutaj rodek kwadratowej pytki)
    double bok;                     //rozmiar przedmiotu
    double r;                       //odlego pytki od obserwatora

    TPrzedmiot( TPunkt Ap0, double bok);//... merytoryczny, ...
    TPrzedmiot( const TPrzedmiot &p);//... kopiujcy,
    TPrzedmiot & operator= (const TPrzedmiot &);//operator przypisania
	bool operator < (const TPrzedmiot &p) const;//operator porwnania

    void dystans( TPunkt obserwator); //algorytm obliczania odlegoci
};
//---------------------------------------------------------------------------
class TForm1 : public TForm
{
__published:	// IDE-managed Components
    TPaintBox *PaintBox1;
    TPanel *Panel1;
    TLabel *Label1;
    TTrackBar *TrackBar1;
    TRadioGroup *RadioGroup1;
    TLabel *Label2;
    TTrackBar *TrackBar2;
    TTrackBar *TrackBar3;
    TTrackBar *TrackBar4;
    TLabel *Label3;
    TTrackBar *TrackBar5;
    void __fastcall PaintBox1Paint(TObject *Sender);
    void __fastcall TrackBar1Change(TObject *Sender);
    void __fastcall FormKeyPress(TObject *Sender, char &Key);
    void __fastcall FormShow(TObject *Sender);
private:    // User declarations
    double baza;
    StylPatrzenia sp;
    TPunkt obserwator;
    double ogniskowa;
    TColor Lkolor1, Rkolor1;    //kontury
    TColor Lkolor2, Rkolor2;    //wypenienia
    void odczytaj_parametry( void);
    void plytka( TStereo *s, TPunkt p, double bok);

	std::vector <TPrzedmiot> przedmioty;
    void inicjuj_scene( void);
    void uporzadkuj_scene( void);
    void renderuj_scene( TStereo *s);
public:	    // User declarations
    __fastcall TForm1(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm1 *Form1;
//---------------------------------------------------------------------------
#endif
